class Turntable
{
  //Global Variables

  AudioPlayer player;
  import ddf.minim.*;
  boolean play = false;
  float armX;
  float armY;
  float testY;
  float testX;
  boolean playSound;
  boolean stopped;

  boolean playing = false;

  color test;
  color defaultColour;

  float[] circlesX = new float[16];
  float[] circlesY = new float[16];

  float[] dataArray = new float[10];
  int[] dataSeq = new int[16];
  int select;
  float tempNumber;
  int seqLength;
  float dataNumber;

  int nbrCircles;
  float lgDiam;
  float lgRad;
  float lgCircle;

  float cX;
  float cY;

  String label;

  color dataColour;

  ball dataBall;
  Minim minim;

  float playPos;

  //Default Constructor

  Turntable(float tempX, float tempY)
  {
    minim = new Minim(this);
    nbrCircles = 16;
    lgDiam = 155;
    lgRad = lgDiam / 2;
    lgCircle = PI * lgDiam;
    label = "";
    dataBall = new ball(26);
    cX = tempX;
    cY = tempY;
    stopped = false;  
    defaultColour = #03B1FF;
    //defaultColour = #1AFFF9;
  }

  private AudioPlayer soundFile (AudioPlayer tempSound)
  {
    player = tempSound;
    return player;
  }

  private float[] getData (float[] tempArray)
  {
    for (int i = 0; i <= 9; i++)
    {
      dataArray[i] = tempArray[i];
    }
    return dataArray;
  }

  private color dataColour (color tempColour)
  {
    dataColour = tempColour;
    return dataColour;
  }

  private String label (String lbl)
  {
    label = lbl; 
    return label;
  }

  private float playPos (float playPosition)
  {
    playPos =  playPosition;
    return playPos;
  }

  public int select (int tempSelect)
  {
    select = tempSelect-1;
    return select;
  }

  void display()
  {
    player.setGain(50);
    noStroke();
    fill(defaultColour, 25);
    ellipse(cX, cY, lgDiam*1.2, lgDiam*1.2);

    for (int i = 0; i <= 15; i++)
    {
      circlesX[i]=0;
      circlesY[i]=0;
    }
    //STEPS CIRCLES
    for (int i = 1; i <= nbrCircles; i++)
    {
      float angle = i * TWO_PI / seqLength;
      float x = cX + cos(angle) * lgRad;
      float y = cY + sin(angle) * lgRad;
      circlesX[i-1] = x;
      circlesY[i-1] = y;

      getSequence();
      if (dataSeq[i-1] == 1)
      {
        dataBall.colour(dataColour);
        dataBall.display(x, y, noise);
      }
    }

    noFill();
    stroke(defaultColour, 10);

    for (int i = 20; i >=0; i=i-1)
    {
      strokeWeight(i);
      ellipse(cX, cY, lgDiam*0.8, lgDiam*0.8);
    }
    stroke(0, 80);
    strokeWeight(3);
    ellipse(cX, cY, lgDiam*1.2, lgDiam*1.2);

    //LINE TONEARM
    float angleY = playPos * TWO_PI /360;
    float x = cX + cos(angleY) * lgRad*1.19;
    float y = cY + sin(angleY) * lgRad*1.19;
    armX = cX + cos(angleY) * lgRad;
    armY = cY + sin(angleY) * lgRad;

    playplayplay();

    strokeCap(SQUARE);
    stroke(defaultColour, 10);
    for (int i = 20; i >=0; i=i-1)
    {
      strokeWeight(i);
      line(cX, cY, x, y);
    }

    stroke(255);
    strokeWeight(2.5);
    line(cX, cY, x, y);

    noStroke();
    fill(0);
    ellipse(cX, cY, lgDiam*0.8, lgDiam*0.8);

    stroke(255);
    fill(255);
    textAlign(CENTER, BOTTOM);
    textFont(myFont2);
    textSize(12);
    text(label, cX, cY);

    for (int i = 0; i < player.bufferSize () - 1; i++)
    {
      float x1 = map(i, 0, player.bufferSize(), cX-60, cX+60);
      float x2 = map(i+1, 0, player.bufferSize(), cX-60, cX+60);
      strokeWeight(1);
      stroke(defaultColour);
      line(x1, cY - player.mix.get(i)*100, x2, cY - player.mix.get(i+1)*100);
    }
    displayNumber(dataNumber);
  }

  void getSequence()
  {

    for (int i = 0; i <= 15; i++)
    {
      dataSeq[i] = 0;
    }
    tempNumber = dataArray[select];
    seqLength = round((tempNumber/2.7)*15);
    dataNumber = round((tempNumber/2.7)*100);
    for (int i = 0; i <= seqLength; i++) 
    {
      dataSeq[i] = 1;
    }
  }

  void triggerSound(boolean tempPlay)
  {
    if (tempPlay == true   && !playing)
    {
      player.rewind();
      player.setGain(0);
      player.play();

      playing = true;
    }
    if (tempPlay == false)
    {
      player.rewind();
    }
  }

  void playplayplay()
  {

    if (armX >= circlesX[9]-5 && armX <= circlesX[9]+5 && armY >= circlesY[9]-5 && armY <= circlesY[9]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[0]-5 && armX <= circlesX[0]+5 && armY >= circlesY[0]-5 && armY <= circlesY[0]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[1]-5 && armX <= circlesX[1]+5 && armY >= circlesY[1]-5 && armY <= circlesY[1]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[2]-5 && armX <= circlesX[2]+5 && armY >= circlesY[2]-5 && armY <= circlesY[2]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[3]-5 && armX <= circlesX[3]+5 && armY >= circlesY[3]-5 && armY <= circlesY[3]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[4]-5 && armX <= circlesX[4]+5 && armY >= circlesY[4]-5 && armY <= circlesY[4]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[5]-5 && armX <= circlesX[5]+5 && armY >= circlesY[5]-5 && armY <= circlesY[5]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[6]-5 && armX <= circlesX[6]+5 && armY >= circlesY[6]-5 && armY <= circlesY[6]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[7]-5 && armX <= circlesX[7]+5 && armY >= circlesY[7]-5 && armY <= circlesY[7]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[8]-5 && armX <= circlesX[8]+5 && armY >= circlesY[8]-5 && armY <= circlesY[8]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[10]-5 && armX <= circlesX[10]+5 && armY >= circlesY[10]-5 && armY <= circlesY[10]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[11]-5 && armX <= circlesX[11]+5 && armY >= circlesY[11]-5 && armY <= circlesY[11]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[12]-5 && armX <= circlesX[12]+5 && armY >= circlesY[12]-5 && armY <= circlesY[12]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[13]-5 && armX <= circlesX[13]+5 && armY >= circlesY[13]-5 && armY <= circlesY[13]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[14]-5 && armX <= circlesX[14]+5 && armY >= circlesY[14]-5 && armY <= circlesY[14]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[15]-5 && armX <= circlesX[15]+5 && armY >= circlesY[15]-5 && armY <= circlesY[15]+5)
    {
      triggerSound(true);
      stopped = false;
    } else
    {
      playing = false;
    }
  }

  public void displayNumber(float number)
  {
    stroke(255);
    fill(255);
    textFont(myFont2);
    text(number+" %", cX,cY+15);
  }
}

