/*
LOUWRENS FERREIRA
 DATA VIZ JUNE 2014
 WITS DIGITAL ART
 PERCEIVED POLLUTION IN GAUTENG
 */


import ddf.minim.*;
Minim minim;

PFont myFont;
PFont myFont2;

AudioPlayer sound1;
AudioPlayer sound2;
AudioPlayer sound3;
AudioPlayer sound4;

PImage img;
String Heading = "";

float[] airArray = new float[10];
float[] landArray = new float[10];
float[] noiseArray = new float[10];
float[] waterArray = new float[10];

int [] aSeq = new int[16];
int [] lSeq = new int[16];
int [] nSeq = new int[16];
int [] wSeq = new int[16];
boolean [] mapSelected = new boolean[10];

String[] municipality = new String[10];

import de.bezier.data.*;

XlsReader reader;

color noise = #2D17FC; 
color water = #03E4FF;
color air = #F3FCDB;
color land = #FFB803;

color playBtnClr = #080500;
color stopBtnClr = #03B1FF;

float phX1 = 325;
float phX2 = 1075;
float phY = 320;
float playPosition = 0;
float playheadPosition = phX1;
int nbrRotations = 4;

int selector = 1;
int seqLength = 0;
float tempNumber;
boolean circlePlayOver = false;
boolean circleStopOver = false;
int startPlay;
boolean clicked = false;

Turntable noiseTurn;
Turntable landTurn;
Turntable airTurn;
Turntable waterTurn;

// total no of images
int numImages = 11;
// image name array
PImage[] imgs = new PImage[numImages];
// x position you want
float mapX = 20;
// y position you want
float mapY =  80;
// map width you want
float mapW = 300;
// map height you want
float mapH = 300;
// var for current roll over
int rollover;

void setup()
{
  Heading = "SELECT MUNICIPALITY";
  startPlay = 0;
  size(800, 600);
  background(255);
  frameRate(100);
  noStroke();
  myFont = loadFont("GillSansMT-20.vlw");
  myFont2 = loadFont("GillSansMT-12.vlw");
  textFont(myFont);
  Heading = "EMFULENI";
  minim = new Minim(this);
  /*
  sound1 = minim.loadFile("noiseSound.wav");
   sound2 = minim.loadFile("airSound.wav");
   sound3 = minim.loadFile("waterSound.wav");
   sound4 = minim.loadFile("landSound.wav");
   */
  sound1 = minim.loadFile("sound1.wav");
  sound2 = minim.loadFile("sound2.wav");
  sound3 = minim.loadFile("sound3.wav");
  sound4 = minim.loadFile("sound4.wav");


  reader = new XlsReader(this, "gcro.xls");

  noiseTurn = new Turntable(440, 180);
  landTurn = new Turntable(650, 180);
  airTurn = new Turntable(390, 370);
  waterTurn = new Turntable(610, 370);

  img = loadImage("map.jpg");
  for (int i = 0; i < numImages; i++) 
  { 
    imgs[i] = loadImage((i+1)+"_GP_Boundaries.png");
  }
}

void draw()
{
  float phX1 = (width/6)*2-75;
  float phX2 = (width/6)*5+75;
  float phY = (height*0.83);
  // background(#182024);
  background(0);
  // tint(3, 177, 255);

  //  image(img, 20, 40, img.width*0.8, img.height*0.8);

  map(mapX, mapY, mapW, mapH);

  textFont(myFont2);
  textSize(14);
  fill(255);
  /*
  textAlign(TOP, CENTER);
   text("0", 161, 114);
   text("1", 97, 219);
   text("2", 128, 205);
   text("3", 180, 195);
   text("4", 90, 150);
   text("5", 76, 172);
   text("6", 85, 190);
   text("7", 60, 190);
   text("8", 150, 168);
   text("9", 116, 167);
   */

  //fill basic arrays
  for (int i = 0; i <= 9; i++)
  {
    airArray[i] = reader.getFloat(i+1, 1);
    landArray[i] = reader.getFloat(i+1, 2);
    noiseArray[i] = reader.getFloat(i+1, 3);
    waterArray[i] = reader.getFloat(i+1, 4);
    municipality[i] = reader.getString(i+1, 10);
  }

  noiseTurn.soundFile(sound1);
  airTurn.soundFile(sound2);
  waterTurn.soundFile(sound3);
  landTurn.soundFile(sound4);

  // Initialise data objects and display
  // Provide them with label, audiofile and array
  noiseTurn.label("NOISE");
  noiseTurn.display();
  noiseTurn.dataColour(noise);
  noiseTurn.getData(noiseArray);


  landTurn.label("LITTER");
  landTurn.display();
  landTurn.dataColour(land);
  landTurn.getData(landArray);


  airTurn.label("AIR");
  airTurn.display();
  airTurn.dataColour(air);
  airTurn.getData(airArray);


  waterTurn.label("WATER");
  waterTurn.display();
  waterTurn.dataColour(water);
  waterTurn.getData(waterArray);




  // Basic Text on Screen
  stroke(255);
  textAlign(BASELINE);
  textSize(20);
  textFont(myFont);
  text(Heading, 50, 60);
  fill(255);
  textFont(myFont2);
  // text("press keys 0 to 9 to between municipalities", 40, height*0.92);
  text("move slider slowly to play the sound", 410, height*0.92);
  textFont(myFont);
  textSize(14);
  fill(255);
  textAlign(CENTER, BASELINE);
  text("TYPES OF POLLUTION REGARDED AS THE BIGGEST PROBLEM", 580, 40);
  text("FACING THE COMMUNITY", 580, 60);

  //Select the correct array to read from

  if (keyPressed == true)
  {
    if (key == '1')
    {
      Heading = municipality[0];
      selector = 1;
    }
    if (key == '2')
    {
      Heading = municipality[1];
      selector = 2;
    }
    if (key == '3')
    {
      Heading = municipality[2];
      selector = 3;
    }
    if (key == '4')
    {
      Heading = municipality[3];
      selector = 4;
    }
    if (key == '5')
    {
      Heading = municipality[4];
      selector = 5;
    }
    if (key == '6')
    {
      Heading = municipality[5];
      selector = 6;
    }
    if (key == '7')
    {
      Heading = municipality[6];
      selector = 7;
    }
    if (key == '8')
    {
      Heading = municipality[7];
      selector = 8;
    }
    if (key == '9')
    {
      Heading = municipality[8];
      selector = 9;
    }
    if (key == '0')
    {
      Heading = municipality[9];
      selector = 10;
    }
  }


  for (int i = 15; i >=0; i--)
  {
    noFill();
    stroke(3, 177, 255, 6*i);
    ellipse(370, 550, 50+i, 50+i);
  }

  for (int i = 15; i >=0; i--)
  {
    noFill();
    stroke(3, 177, 255, 6*i);
    ellipse(630, 550, 50+i, 50+i);
  }

  fill(playBtnClr, 200);
  strokeWeight(2);
  stroke(255, 0);
  ellipse(370, 550, 50, 50);
  fill(stopBtnClr, 200);
  ellipse(630, 550, 50, 50);
  fill(255);
  textFont(myFont2);
  text("PLAY", 371, 555);
  text("STOP", 631, 555);


  if (overCircle(370, 550, 50)) 
  {
    circlePlayOver = true;
    circleStopOver = false;
  }

  if (overCircle2(630, 550, 50))
  {
    circlePlayOver = false;
    circleStopOver = true;
  } 

  if ((circlePlayOver) && (mousePressed))
  {
    startPlay = 1;
    playBtnClr = #03B1FF;
    stopBtnClr = #000505;
  }

  if ((circleStopOver) && (mousePressed))
  {
    startPlay = 0;
    playBtnClr = #000505;
    stopBtnClr = #03B1FF;
  }

  noiseTurn.select(selector);
  airTurn.select(selector);
  waterTurn.select(selector);
  landTurn.select(selector);
  playhead(280, phX2, phY);
}

//this function places the playhead on the screen and follows the mouse
//a value is sent to the turntable objects to move the "tone arm"

void playhead(float myX1, float myX2, float myY)
{
  strokeWeight(2);
  stroke(3, 177, 255);
  line(myX1, myY, myX2, myY);
  ellipse(myX1, myY, 5, 5);
  ellipse(myX2, myY, 5, 5);

  if (mouseX >= myX1 && mouseX <= myX2 && mouseY >= myY-30 && mouseY <= myY+30)
  {
    playPosition = map(mouseX, myX1, myX2, 0, 360*nbrRotations);
    airTurn.playPos(playPosition);
    waterTurn.playPos(playPosition);
    landTurn.playPos(playPosition);
    noiseTurn.playPos(playPosition);
    playheadPosition = mouseX;
  } else
  {
    playheadPosition = playheadPosition+startPlay;
    if (playheadPosition > myX2) {
      playheadPosition = myX1;
    }
    playPosition = map(playheadPosition, myX1, myX2, 0, 360*nbrRotations);
    airTurn.playPos(playPosition);
    waterTurn.playPos(playPosition);
    landTurn.playPos(playPosition);
    noiseTurn.playPos(playPosition);
  }
  for (int i = 10; i >=0; i--)
  {
    noFill();
    stroke(3, 177, 255, 6*i);
    ellipse(playheadPosition, myY, 15+i, 15+i);
  }
  fill(noise, 200);
  noStroke();
  ellipse(83, 440, 26, 26);
  fill(land);
  ellipse(128, 440, 26, 26);
  fill(air);
  ellipse(173, 440, 26, 26);
  fill(water);
  ellipse(220, 440, 26, 26);
  textAlign(BASELINE);
  fill(255);
  text("Each dot represents a percentage", 70, 475);
  text("in relation to the total amount of", 70, 495);
  text("complaints about pollution in the", 70, 515);
  text("Municipality", 70, 535);
}

void map(float mx, float my, float mw, float mh) 
{

  // no. 10 the base map
  // here at 50% size and tinted grey
  tint(#BFEBFF, 60);
  // base map size
  imgs[10].resize(int(mw), int(mh));
  // base map position
  image(imgs[10], mx, my);

  // roll overs based on mx, my, mh, mw - so that you can change the placement and size easily
  // so don't change these - only mx, my, mw and mh
  if (mouseX > mx+(mw/2) && mouseX < mx+mw && mouseY > my && mouseY < my+(mh/2.4) ) {
    rollover = 0;
    Heading = municipality[0];
  } 

  if (mouseX > mx+(mw/5.7) && mouseX < mx+(mw/2.6) && mouseY > my+(mh/2.5) && mouseY < my+(mh/1.9) ) {
    rollover = 1;
    Heading = municipality[1];
  } 

  if (mouseX > mx+(mw/2.6) && mouseX < mx+(mw/2) && mouseY > my+(mh/2.4) && mouseY < my+(mh/1.5) ) { 
    rollover = 2;
    Heading = municipality[2];
  } 

  if (mouseX > mx+(mw/2) && mouseX < mx+(mw/1.4) && mouseY > my+(mh/2.4) && mouseY < my+(mh/1.5) ) { 
    rollover = 3;
    Heading = municipality[3];
  } 

  if (mouseX > mx+(mw/1.8) && mouseX < mx+(mw/1.16) && mouseY > my+(mh/1.65) && mouseY < my+(mh/1.2) ) { 
    rollover = 4;
    Heading = municipality[4];
  } 

  if (mouseX > mx+(mw/2.6) && mouseX < mx+(mw/1.8) && mouseY > my+(mh/1.4) && mouseY < my+(mh) ) { 
    rollover = 5;
    Heading = municipality[5];
  } 

  if (mouseX > mx+(mw/3.7) && mouseX < mx+(mw/2.6) && mouseY > my+(mh/1.35) && mouseY < my+(mh/1.1) ) { 
    rollover = 6;
    Heading = municipality[6];
  } 

  if (mouseX > mx+(mw/4.7) && mouseX < mx+(mw/3.7) && mouseY > my+(mh/1.55) && mouseY < my+(mh/1.3) ) { 
    rollover = 7;
    Heading = municipality[7];
  } 

  if (mouseX > mx+(mw/5.5) && mouseX < mx+(mw/3.5) && mouseY > my+(mh/1.9) && mouseY < my+(mh/1.6) ) { 
    rollover = 8;
   Heading = municipality[8];
  } 

  if (mouseX > mx && mouseX < mx+(mw/5) && mouseY > my+(mh/1.8) && mouseY < my+(mh/1.2) ) { 
    rollover = 9;
    Heading = municipality[9];
  } 
if (mouseX >= 800 || mouseX <= 0 ||  mouseY >= 600 || mouseY <= 0) {
    rollover = 10;
  } 
  // if not in the map space
  

  // points to the current roll over
  if (rollover <= 9) 
  {
    // tinted light blue (you can add alpha if you want
    tint(3, 177, 255, 200);
    selector = rollover+1;
    //Heading = municipality[rollover];
    // resize the same as base map
    imgs[rollover].resize(int(mw), int(mh));
    // position the same as base map
    image(imgs[rollover], mx, my);
  }
}
boolean overCircle(int x, int y, int diameter) {
  float disX = x - mouseX;
  float disY = y - mouseY;
  if (sqrt(sq(disX) + sq(disY)) < diameter/2 ) {
    return true;
  } else {
    return false;
  }
}

boolean overCircle2(int x, int y, int diameter) {
  float disX = x - mouseX;
  float disY = y - mouseY;
  if (sqrt(sq(disX) + sq(disY)) < diameter/2 ) {
    return true;
  } else {
    return false;
  }
}

void clearMapSelected()
{
  for (int i = 0; i <=9; i++)
  {
    mapSelected[i] = false;
  }
}

