import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import ddf.minim.*; 
import de.bezier.data.*; 
import ddf.minim.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class GCRO_Pollution_Louwrens extends PApplet {

/*
LOUWRENS FERREIRA
 DATA VIZ JUNE 2014
 WITS DIGITAL ART
 PERCEIVED POLLUTION IN GAUTENG
 */



Minim minim;

PFont myFont;
PFont myFont2;

AudioPlayer sound1;
AudioPlayer sound2;
AudioPlayer sound3;
AudioPlayer sound4;

PImage img;
String Heading = "";

float[] airArray = new float[10];
float[] landArray = new float[10];
float[] noiseArray = new float[10];
float[] waterArray = new float[10];

int [] aSeq = new int[16];
int [] lSeq = new int[16];
int [] nSeq = new int[16];
int [] wSeq = new int[16];
boolean [] mapSelected = new boolean[10];

String[] municipality = new String[10];



XlsReader reader;

int noise = 0xff2D17FC; 
int water = 0xff03E4FF;
int air = 0xffF3FCDB;
int land = 0xffFFB803;

int playBtnClr = 0xff080500;
int stopBtnClr = 0xff03B1FF;

float phX1 = 325;
float phX2 = 1075;
float phY = 320;
float playPosition = 0;
float playheadPosition = phX1;
int nbrRotations = 4;

int selector = 1;
int seqLength = 0;
float tempNumber;
boolean circlePlayOver = false;
boolean circleStopOver = false;
int startPlay;
boolean clicked = false;

Turntable noiseTurn;
Turntable landTurn;
Turntable airTurn;
Turntable waterTurn;

// total no of images
int numImages = 11;
// image name array
PImage[] imgs = new PImage[numImages];
// x position you want
float mapX = 20;
// y position you want
float mapY =  80;
// map width you want
float mapW = 300;
// map height you want
float mapH = 300;
// var for current roll over
int rollover;

public void setup()
{
  Heading = "SELECT MUNICIPALITY";
  startPlay = 0;
  size(800, 600);
  background(255);
  frameRate(100);
  noStroke();
  myFont = loadFont("GillSansMT-20.vlw");
  myFont2 = loadFont("GillSansMT-12.vlw");
  textFont(myFont);
  Heading = "EMFULENI";
  minim = new Minim(this);
  /*
  sound1 = minim.loadFile("noiseSound.wav");
   sound2 = minim.loadFile("airSound.wav");
   sound3 = minim.loadFile("waterSound.wav");
   sound4 = minim.loadFile("landSound.wav");
   */
  sound1 = minim.loadFile("sound1.wav");
  sound2 = minim.loadFile("sound2.wav");
  sound3 = minim.loadFile("sound3.wav");
  sound4 = minim.loadFile("sound4.wav");


  reader = new XlsReader(this, "gcro.xls");

  noiseTurn = new Turntable(440, 180);
  landTurn = new Turntable(650, 180);
  airTurn = new Turntable(390, 370);
  waterTurn = new Turntable(610, 370);

  img = loadImage("map.jpg");
  for (int i = 0; i < numImages; i++) 
  { 
    imgs[i] = loadImage((i+1)+"_GP_Boundaries.png");
  }
}

public void draw()
{
  float phX1 = (width/6)*2-75;
  float phX2 = (width/6)*5+75;
  float phY = (height*0.83f);
  // background(#182024);
  background(0);
  // tint(3, 177, 255);

  //  image(img, 20, 40, img.width*0.8, img.height*0.8);

  map(mapX, mapY, mapW, mapH);

  textFont(myFont2);
  textSize(14);
  fill(255);
  /*
  textAlign(TOP, CENTER);
   text("0", 161, 114);
   text("1", 97, 219);
   text("2", 128, 205);
   text("3", 180, 195);
   text("4", 90, 150);
   text("5", 76, 172);
   text("6", 85, 190);
   text("7", 60, 190);
   text("8", 150, 168);
   text("9", 116, 167);
   */

  //fill basic arrays
  for (int i = 0; i <= 9; i++)
  {
    airArray[i] = reader.getFloat(i+1, 1);
    landArray[i] = reader.getFloat(i+1, 2);
    noiseArray[i] = reader.getFloat(i+1, 3);
    waterArray[i] = reader.getFloat(i+1, 4);
    municipality[i] = reader.getString(i+1, 10);
  }

  noiseTurn.soundFile(sound1);
  airTurn.soundFile(sound2);
  waterTurn.soundFile(sound3);
  landTurn.soundFile(sound4);

  // Initialise data objects and display
  // Provide them with label, audiofile and array
  noiseTurn.label("NOISE");
  noiseTurn.display();
  noiseTurn.dataColour(noise);
  noiseTurn.getData(noiseArray);


  landTurn.label("LITTER");
  landTurn.display();
  landTurn.dataColour(land);
  landTurn.getData(landArray);


  airTurn.label("AIR");
  airTurn.display();
  airTurn.dataColour(air);
  airTurn.getData(airArray);


  waterTurn.label("WATER");
  waterTurn.display();
  waterTurn.dataColour(water);
  waterTurn.getData(waterArray);




  // Basic Text on Screen
  stroke(255);
  textAlign(BASELINE);
  textSize(20);
  textFont(myFont);
  text(Heading, 50, 60);
  fill(255);
  textFont(myFont2);
  // text("press keys 0 to 9 to between municipalities", 40, height*0.92);
  text("move slider slowly to play the sound", 410, height*0.92f);
  textFont(myFont);
  textSize(14);
  fill(255);
  textAlign(CENTER, BASELINE);
  text("TYPES OF POLLUTION REGARDED AS THE BIGGEST PROBLEM", 580, 40);
  text("FACING THE COMMUNITY", 580, 60);

  //Select the correct array to read from

  if (keyPressed == true)
  {
    if (key == '1')
    {
      Heading = municipality[0];
      selector = 1;
    }
    if (key == '2')
    {
      Heading = municipality[1];
      selector = 2;
    }
    if (key == '3')
    {
      Heading = municipality[2];
      selector = 3;
    }
    if (key == '4')
    {
      Heading = municipality[3];
      selector = 4;
    }
    if (key == '5')
    {
      Heading = municipality[4];
      selector = 5;
    }
    if (key == '6')
    {
      Heading = municipality[5];
      selector = 6;
    }
    if (key == '7')
    {
      Heading = municipality[6];
      selector = 7;
    }
    if (key == '8')
    {
      Heading = municipality[7];
      selector = 8;
    }
    if (key == '9')
    {
      Heading = municipality[8];
      selector = 9;
    }
    if (key == '0')
    {
      Heading = municipality[9];
      selector = 10;
    }
  }


  for (int i = 15; i >=0; i--)
  {
    noFill();
    stroke(3, 177, 255, 6*i);
    ellipse(370, 550, 50+i, 50+i);
  }

  for (int i = 15; i >=0; i--)
  {
    noFill();
    stroke(3, 177, 255, 6*i);
    ellipse(630, 550, 50+i, 50+i);
  }

  fill(playBtnClr, 200);
  strokeWeight(2);
  stroke(255, 0);
  ellipse(370, 550, 50, 50);
  fill(stopBtnClr, 200);
  ellipse(630, 550, 50, 50);
  fill(255);
  textFont(myFont2);
  text("PLAY", 371, 555);
  text("STOP", 631, 555);


  if (overCircle(370, 550, 50)) 
  {
    circlePlayOver = true;
    circleStopOver = false;
  }

  if (overCircle2(630, 550, 50))
  {
    circlePlayOver = false;
    circleStopOver = true;
  } 

  if ((circlePlayOver) && (mousePressed))
  {
    startPlay = 1;
    playBtnClr = 0xff03B1FF;
    stopBtnClr = 0xff000505;
  }

  if ((circleStopOver) && (mousePressed))
  {
    startPlay = 0;
    playBtnClr = 0xff000505;
    stopBtnClr = 0xff03B1FF;
  }

  noiseTurn.select(selector);
  airTurn.select(selector);
  waterTurn.select(selector);
  landTurn.select(selector);
  playhead(280, phX2, phY);
}

//this function places the playhead on the screen and follows the mouse
//a value is sent to the turntable objects to move the "tone arm"

public void playhead(float myX1, float myX2, float myY)
{
  strokeWeight(2);
  stroke(3, 177, 255);
  line(myX1, myY, myX2, myY);
  ellipse(myX1, myY, 5, 5);
  ellipse(myX2, myY, 5, 5);

  if (mouseX >= myX1 && mouseX <= myX2 && mouseY >= myY-30 && mouseY <= myY+30)
  {
    playPosition = map(mouseX, myX1, myX2, 0, 360*nbrRotations);
    airTurn.playPos(playPosition);
    waterTurn.playPos(playPosition);
    landTurn.playPos(playPosition);
    noiseTurn.playPos(playPosition);
    playheadPosition = mouseX;
  } else
  {
    playheadPosition = playheadPosition+startPlay;
    if (playheadPosition > myX2) {
      playheadPosition = myX1;
    }
    playPosition = map(playheadPosition, myX1, myX2, 0, 360*nbrRotations);
    airTurn.playPos(playPosition);
    waterTurn.playPos(playPosition);
    landTurn.playPos(playPosition);
    noiseTurn.playPos(playPosition);
  }
  for (int i = 10; i >=0; i--)
  {
    noFill();
    stroke(3, 177, 255, 6*i);
    ellipse(playheadPosition, myY, 15+i, 15+i);
  }
  fill(noise, 200);
  noStroke();
  ellipse(83, 440, 26, 26);
  fill(land);
  ellipse(128, 440, 26, 26);
  fill(air);
  ellipse(173, 440, 26, 26);
  fill(water);
  ellipse(220, 440, 26, 26);
  textAlign(BASELINE);
  fill(255);
  text("Each dot represents a percentage", 70, 475);
  text("in relation to the total amount of", 70, 495);
  text("complaints about pollution in the", 70, 515);
  text("Municipality", 70, 535);
}

public void map(float mx, float my, float mw, float mh) 
{

  // no. 10 the base map
  // here at 50% size and tinted grey
  tint(0xffBFEBFF, 60);
  // base map size
  imgs[10].resize(PApplet.parseInt(mw), PApplet.parseInt(mh));
  // base map position
  image(imgs[10], mx, my);

  // roll overs based on mx, my, mh, mw - so that you can change the placement and size easily
  // so don't change these - only mx, my, mw and mh
  if (mouseX > mx+(mw/2) && mouseX < mx+mw && mouseY > my && mouseY < my+(mh/2.4f) ) {
    rollover = 0;
    Heading = municipality[0];
  } 

  if (mouseX > mx+(mw/5.7f) && mouseX < mx+(mw/2.6f) && mouseY > my+(mh/2.5f) && mouseY < my+(mh/1.9f) ) {
    rollover = 1;
    Heading = municipality[1];
  } 

  if (mouseX > mx+(mw/2.6f) && mouseX < mx+(mw/2) && mouseY > my+(mh/2.4f) && mouseY < my+(mh/1.5f) ) { 
    rollover = 2;
    Heading = municipality[2];
  } 

  if (mouseX > mx+(mw/2) && mouseX < mx+(mw/1.4f) && mouseY > my+(mh/2.4f) && mouseY < my+(mh/1.5f) ) { 
    rollover = 3;
    Heading = municipality[3];
  } 

  if (mouseX > mx+(mw/1.8f) && mouseX < mx+(mw/1.16f) && mouseY > my+(mh/1.65f) && mouseY < my+(mh/1.2f) ) { 
    rollover = 4;
    Heading = municipality[4];
  } 

  if (mouseX > mx+(mw/2.6f) && mouseX < mx+(mw/1.8f) && mouseY > my+(mh/1.4f) && mouseY < my+(mh) ) { 
    rollover = 5;
    Heading = municipality[5];
  } 

  if (mouseX > mx+(mw/3.7f) && mouseX < mx+(mw/2.6f) && mouseY > my+(mh/1.35f) && mouseY < my+(mh/1.1f) ) { 
    rollover = 6;
    Heading = municipality[6];
  } 

  if (mouseX > mx+(mw/4.7f) && mouseX < mx+(mw/3.7f) && mouseY > my+(mh/1.55f) && mouseY < my+(mh/1.3f) ) { 
    rollover = 7;
    Heading = municipality[7];
  } 

  if (mouseX > mx+(mw/5.5f) && mouseX < mx+(mw/3.5f) && mouseY > my+(mh/1.9f) && mouseY < my+(mh/1.6f) ) { 
    rollover = 8;
   Heading = municipality[8];
  } 

  if (mouseX > mx && mouseX < mx+(mw/5) && mouseY > my+(mh/1.8f) && mouseY < my+(mh/1.2f) ) { 
    rollover = 9;
    Heading = municipality[9];
  } 
if (mouseX >= 800 || mouseX <= 0 ||  mouseY >= 600 || mouseY <= 0) {
    rollover = 10;
  } 
  // if not in the map space
  

  // points to the current roll over
  if (rollover <= 9) 
  {
    // tinted light blue (you can add alpha if you want
    tint(3, 177, 255, 200);
    selector = rollover+1;
    //Heading = municipality[rollover];
    // resize the same as base map
    imgs[rollover].resize(PApplet.parseInt(mw), PApplet.parseInt(mh));
    // position the same as base map
    image(imgs[rollover], mx, my);
  }
}
public boolean overCircle(int x, int y, int diameter) {
  float disX = x - mouseX;
  float disY = y - mouseY;
  if (sqrt(sq(disX) + sq(disY)) < diameter/2 ) {
    return true;
  } else {
    return false;
  }
}

public boolean overCircle2(int x, int y, int diameter) {
  float disX = x - mouseX;
  float disY = y - mouseY;
  if (sqrt(sq(disX) + sq(disY)) < diameter/2 ) {
    return true;
  } else {
    return false;
  }
}

public void clearMapSelected()
{
  for (int i = 0; i <=9; i++)
  {
    mapSelected[i] = false;
  }
}

class Turntable
{
  //Global Variables

  AudioPlayer player;
  
  boolean play = false;
  float armX;
  float armY;
  float testY;
  float testX;
  boolean playSound;
  boolean stopped;

  boolean playing = false;

  int test;
  int defaultColour;

  float[] circlesX = new float[16];
  float[] circlesY = new float[16];

  float[] dataArray = new float[10];
  int[] dataSeq = new int[16];
  int select;
  float tempNumber;
  int seqLength;
  float dataNumber;

  int nbrCircles;
  float lgDiam;
  float lgRad;
  float lgCircle;

  float cX;
  float cY;

  String label;

  int dataColour;

  ball dataBall;
  Minim minim;

  float playPos;

  //Default Constructor

  Turntable(float tempX, float tempY)
  {
    minim = new Minim(this);
    nbrCircles = 16;
    lgDiam = 155;
    lgRad = lgDiam / 2;
    lgCircle = PI * lgDiam;
    label = "";
    dataBall = new ball(26);
    cX = tempX;
    cY = tempY;
    stopped = false;  
    defaultColour = 0xff03B1FF;
    //defaultColour = #1AFFF9;
  }

  private AudioPlayer soundFile (AudioPlayer tempSound)
  {
    player = tempSound;
    return player;
  }

  private float[] getData (float[] tempArray)
  {
    for (int i = 0; i <= 9; i++)
    {
      dataArray[i] = tempArray[i];
    }
    return dataArray;
  }

  private int dataColour (int tempColour)
  {
    dataColour = tempColour;
    return dataColour;
  }

  private String label (String lbl)
  {
    label = lbl; 
    return label;
  }

  private float playPos (float playPosition)
  {
    playPos =  playPosition;
    return playPos;
  }

  public int select (int tempSelect)
  {
    select = tempSelect-1;
    return select;
  }

  public void display()
  {
    player.setGain(50);
    noStroke();
    fill(defaultColour, 25);
    ellipse(cX, cY, lgDiam*1.2f, lgDiam*1.2f);

    for (int i = 0; i <= 15; i++)
    {
      circlesX[i]=0;
      circlesY[i]=0;
    }
    //STEPS CIRCLES
    for (int i = 1; i <= nbrCircles; i++)
    {
      float angle = i * TWO_PI / seqLength;
      float x = cX + cos(angle) * lgRad;
      float y = cY + sin(angle) * lgRad;
      circlesX[i-1] = x;
      circlesY[i-1] = y;

      getSequence();
      if (dataSeq[i-1] == 1)
      {
        dataBall.colour(dataColour);
        dataBall.display(x, y, noise);
      }
    }

    noFill();
    stroke(defaultColour, 10);

    for (int i = 20; i >=0; i=i-1)
    {
      strokeWeight(i);
      ellipse(cX, cY, lgDiam*0.8f, lgDiam*0.8f);
    }
    stroke(0, 80);
    strokeWeight(3);
    ellipse(cX, cY, lgDiam*1.2f, lgDiam*1.2f);

    //LINE TONEARM
    float angleY = playPos * TWO_PI /360;
    float x = cX + cos(angleY) * lgRad*1.19f;
    float y = cY + sin(angleY) * lgRad*1.19f;
    armX = cX + cos(angleY) * lgRad;
    armY = cY + sin(angleY) * lgRad;

    playplayplay();

    strokeCap(SQUARE);
    stroke(defaultColour, 10);
    for (int i = 20; i >=0; i=i-1)
    {
      strokeWeight(i);
      line(cX, cY, x, y);
    }

    stroke(255);
    strokeWeight(2.5f);
    line(cX, cY, x, y);

    noStroke();
    fill(0);
    ellipse(cX, cY, lgDiam*0.8f, lgDiam*0.8f);

    stroke(255);
    fill(255);
    textAlign(CENTER, BOTTOM);
    textFont(myFont2);
    textSize(12);
    text(label, cX, cY);

    for (int i = 0; i < player.bufferSize () - 1; i++)
    {
      float x1 = map(i, 0, player.bufferSize(), cX-60, cX+60);
      float x2 = map(i+1, 0, player.bufferSize(), cX-60, cX+60);
      strokeWeight(1);
      stroke(defaultColour);
      line(x1, cY - player.mix.get(i)*100, x2, cY - player.mix.get(i+1)*100);
    }
    displayNumber(dataNumber);
  }

  public void getSequence()
  {

    for (int i = 0; i <= 15; i++)
    {
      dataSeq[i] = 0;
    }
    tempNumber = dataArray[select];
    seqLength = round((tempNumber/2.7f)*15);
    dataNumber = round((tempNumber/2.7f)*100);
    for (int i = 0; i <= seqLength; i++) 
    {
      dataSeq[i] = 1;
    }
  }

  public void triggerSound(boolean tempPlay)
  {
    if (tempPlay == true   && !playing)
    {
      player.rewind();
      player.setGain(0);
      player.play();

      playing = true;
    }
    if (tempPlay == false)
    {
      player.rewind();
    }
  }

  public void playplayplay()
  {

    if (armX >= circlesX[9]-5 && armX <= circlesX[9]+5 && armY >= circlesY[9]-5 && armY <= circlesY[9]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[0]-5 && armX <= circlesX[0]+5 && armY >= circlesY[0]-5 && armY <= circlesY[0]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[1]-5 && armX <= circlesX[1]+5 && armY >= circlesY[1]-5 && armY <= circlesY[1]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[2]-5 && armX <= circlesX[2]+5 && armY >= circlesY[2]-5 && armY <= circlesY[2]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[3]-5 && armX <= circlesX[3]+5 && armY >= circlesY[3]-5 && armY <= circlesY[3]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[4]-5 && armX <= circlesX[4]+5 && armY >= circlesY[4]-5 && armY <= circlesY[4]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[5]-5 && armX <= circlesX[5]+5 && armY >= circlesY[5]-5 && armY <= circlesY[5]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[6]-5 && armX <= circlesX[6]+5 && armY >= circlesY[6]-5 && armY <= circlesY[6]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[7]-5 && armX <= circlesX[7]+5 && armY >= circlesY[7]-5 && armY <= circlesY[7]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[8]-5 && armX <= circlesX[8]+5 && armY >= circlesY[8]-5 && armY <= circlesY[8]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[10]-5 && armX <= circlesX[10]+5 && armY >= circlesY[10]-5 && armY <= circlesY[10]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[11]-5 && armX <= circlesX[11]+5 && armY >= circlesY[11]-5 && armY <= circlesY[11]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[12]-5 && armX <= circlesX[12]+5 && armY >= circlesY[12]-5 && armY <= circlesY[12]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[13]-5 && armX <= circlesX[13]+5 && armY >= circlesY[13]-5 && armY <= circlesY[13]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[14]-5 && armX <= circlesX[14]+5 && armY >= circlesY[14]-5 && armY <= circlesY[14]+5)
    {
      triggerSound(true);
      stopped = false;
    } else if (armX >= circlesX[15]-5 && armX <= circlesX[15]+5 && armY >= circlesY[15]-5 && armY <= circlesY[15]+5)
    {
      triggerSound(true);
      stopped = false;
    } else
    {
      playing = false;
    }
  }

  public void displayNumber(float number)
  {
    stroke(255);
    fill(255);
    textFont(myFont2);
    text(number+" %", cX,cY+15);
  }
}

class ball
{
  float smDiam;
  float xPos;
  float yPos;
  int c;

  //default contructor
  ball()
  {
    smDiam = 20;
    xPos= 0;
    yPos = 0;
    c = 255;
  }

  //if diameter is defined
  ball(int di)
  {
    smDiam = di;
    xPos= 0;
    yPos = 0;
    c = 255;
  }
  //Receive Colour for the balls.
  private int colour (int tempColour)
  {
    c = tempColour;
    return c;
  }

  public void display(float tempX, float tempY, int tempC)
  {
    xPos = tempX;
    yPos = tempY;


    //noStroke();
      noStroke();
      fill(c);
      ellipse(xPos, yPos, smDiam, smDiam);
    
  }
}

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "GCRO_Pollution_Louwrens" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
