/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import sun.misc.Unsafe;
import sun.nio.ch.Util;

class KQueue {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int SIZEOF_KQUEUEEVENT = KQueue.keventSize();
    private static final int OFFSET_IDENT = KQueue.identOffset();
    private static final int OFFSET_FILTER = KQueue.filterOffset();
    private static final int OFFSET_FLAGS = KQueue.flagsOffset();
    static final int EVFILT_READ = -1;
    static final int EVFILT_WRITE = -2;
    static final int EV_ADD = 1;
    static final int EV_ONESHOT = 16;
    static final int EV_CLEAR = 32;

    private KQueue() {
    }

    static long allocatePollArray(int n) {
        return unsafe.allocateMemory(n * SIZEOF_KQUEUEEVENT);
    }

    static void freePollArray(long l) {
        unsafe.freeMemory(l);
    }

    static long getEvent(long l, int n) {
        return l + (long)(SIZEOF_KQUEUEEVENT * n);
    }

    static int getDescriptor(long l) {
        return unsafe.getInt(l + (long)OFFSET_IDENT);
    }

    static int getFilter(long l) {
        return unsafe.getShort(l + (long)OFFSET_FILTER);
    }

    static int getFlags(long l) {
        return unsafe.getShort(l + (long)OFFSET_FLAGS);
    }

    private static native int keventSize();

    private static native int identOffset();

    private static native int filterOffset();

    private static native int flagsOffset();

    static native int kqueue() throws IOException;

    static native int keventRegister(int var0, int var1, int var2, int var3);

    static native int keventPoll(int var0, long var1, int var3) throws IOException;

    static {
        Util.load();
    }
}

