/*
 * Decompiled with CFR 0.152.
 */
package de.bezier.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import processing.core.PApplet;

public class XlsReader {
    private PApplet papplet;
    Iterator rowIterator;
    Iterator cellIterator;
    String xlsFile;
    HSSFWorkbook workBook;
    int sheetNum = -1;
    HSSFSheet sheet;
    int rowNum;
    HSSFRow row;
    int cellNum;
    HSSFCell cell;
    private boolean showWarnings = true;

    public XlsReader(PApplet pApplet, String string) {
        this.papplet = pApplet;
        this.xlsFile = string;
        InputStream inputStream = this.papplet.createInput(this.xlsFile);
        if (inputStream == null) {
            PApplet.println((String)"ERR, XlsReader(): file not found or unable to read");
            return;
        }
        POIFSFileSystem pOIFSFileSystem = null;
        try {
            pOIFSFileSystem = new POIFSFileSystem(inputStream);
            this.workBook = new HSSFWorkbook(pOIFSFileSystem);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            PApplet.println((String)"ERR, XlsReader(): file not found or unable to read");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PApplet.println((String)"ERR, XlsReader(): general error");
        }
        this.openSheet(0);
    }

    public void showWarnings(boolean bl) {
        this.showWarnings = bl;
    }

    public void openSheet(int n) {
        if (this.workBook == null) {
            return;
        }
        if (this.sheetNum != n) {
            this.sheetNum = n;
            this.sheet = this.workBook.getSheetAt(this.sheetNum);
            this.resetAll();
        }
    }

    private void resetAll() {
        this.row = null;
        this.cell = null;
        this.rowIterator = null;
        this.cellIterator = null;
        this.rowNum = -1;
        this.cellNum = -1;
    }

    public int getFirstRowNum() {
        if (this.sheet != null) {
            return this.sheet.getFirstRowNum();
        }
        PApplet.println((String)"ERR, getFirstRowNum(): sheet is null");
        return -1;
    }

    public int getRowNum() {
        if (this.sheet != null) {
            return this.rowNum;
        }
        PApplet.println((String)"ERR, getRowNum (): sheet is null");
        return -1;
    }

    public int getLastRowNum() {
        if (this.sheet != null) {
            return this.sheet.getLastRowNum();
        }
        PApplet.println((String)"ERR, getLastRowNum(): sheet is null");
        return -1;
    }

    private void resetRow() {
        this.rowIterator = null;
        this.initRowIterator();
    }

    private void selectRow(int n) {
        if (this.sheet == null) {
            PApplet.println((String)"ERR, selectRow(): sheet is null");
        }
        this.row = this.sheet.getRow(n);
        this.rowNum = n;
        if (this.row == null) {
            PApplet.println((String)"ERR, selectRow(): row returned null");
        }
    }

    private void initRowIterator() {
        if (this.sheet == null) {
            PApplet.println((String)"ERR, initRowIterator(): sheet is null");
        }
        if (this.rowIterator == null) {
            this.rowIterator = this.sheet.rowIterator();
        }
        if (this.rowIterator == null) {
            PApplet.println((String)"ERR, initRowIterator(): iterator is null");
        }
    }

    public void firstRow() {
        this.resetRow();
        this.nextRow();
    }

    public void nextRow() {
        this.initRowIterator();
        if (this.rowIterator.hasNext()) {
            this.row = (HSSFRow)this.rowIterator.next();
            this.rowNum = this.row.getRowNum();
            this.firstCell();
        }
    }

    public boolean hasMoreRows() {
        if (this.rowIterator == null) {
            this.resetRow();
        }
        return this.rowIterator.hasNext();
    }

    public boolean hasMoreCells() {
        if (this.cellIterator == null) {
            this.resetCell();
        }
        return this.cellIterator.hasNext();
    }

    private int getFirstCellNum() {
        if (this.row != null) {
            return this.row.getFirstCellNum();
        }
        PApplet.println((String)"ERR, getFirstCellNum(): row is null");
        return -1;
    }

    public int getCellNum() {
        if (this.sheet != null) {
            return this.cellNum;
        }
        PApplet.println((String)"ERR, getCellNum (): sheet is null");
        return -1;
    }

    private int getLastCellNum() {
        if (this.row != null) {
            return this.row.getLastCellNum();
        }
        PApplet.println((String)"ERR, getLastCellNum(): row is null");
        return -1;
    }

    public void resetCell() {
        this.cellIterator = null;
        this.cell = null;
        if (this.row == null) {
            this.resetRow();
        }
    }

    private void initCellIterator() {
        if (this.row == null) {
            this.firstRow();
        }
        if (this.row == null) {
            PApplet.println((String)"ERR, nextCell(): row is null");
            return;
        }
        if (this.cellIterator == null) {
            this.cellIterator = this.row.cellIterator();
        }
        if (this.cellIterator == null) {
            PApplet.println((String)"ERR, nextCell(): iterator is null");
        }
    }

    public void firstCell() {
        this.resetCell();
        this.nextCell();
    }

    public void nextCell() {
        this.initCellIterator();
        if (this.cellIterator.hasNext()) {
            this.cell = (HSSFCell)this.cellIterator.next();
            this.cellNum = this.cell.getCellNum();
        }
    }

    public String getString() {
        if (this.cell != null) {
            String string;
            block4: {
                string = null;
                try {
                    string = this.cell.getRichStringCellValue().toString();
                }
                catch (NumberFormatException numberFormatException) {
                    if (!this.showWarnings) break block4;
                    PApplet.println((String)"ERR, getString(): you are reading a numeric cell as string.");
                }
            }
            if (string == null) {
                string = this.cell.getNumericCellValue() + "";
            }
            return string;
        }
        PApplet.println((String)"ERR, no cell selected! call firstCell() first.");
        return null;
    }

    public int getInt() {
        if (this.cell != null) {
            try {
                int n = (int)this.cell.getNumericCellValue();
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                if (this.showWarnings) {
                    PApplet.println((String)"ERR, getInt(): you are reading a text cell as int.");
                }
                int n = Integer.parseInt(this.cell.getRichStringCellValue().toString().trim());
                return n;
            }
        }
        PApplet.println((String)"ERR, no cell selected! call firstCell() first.");
        return -1;
    }

    public float getFloat() {
        if (this.cell != null) {
            try {
                float f = (float)this.cell.getNumericCellValue();
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                if (this.showWarnings) {
                    PApplet.println((String)"ERR, getFloat(): you are reading a text cell as float.");
                }
                float f = Float.parseFloat(this.cell.getRichStringCellValue().toString().trim());
                return f;
            }
        }
        PApplet.println((String)"ERR, no cell selected! call firstCell() first.");
        return -1.0f;
    }

    public int getInt(int n, int n2) {
        this.cell = this.getCell(n, n2);
        if (this.cell == null) {
            PApplet.println((String)"ERR, getInt(): cell is null");
        }
        if (!this.isCellType(this.cell, 0)) {
            PApplet.println((String)"ERR, getInt(): wrong celltype");
        }
        try {
            int n3 = (int)this.cell.getNumericCellValue();
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.showWarnings) {
                PApplet.println((String)("ERR, getInt(" + n + "," + n2 + "): you are reading a text cell as int."));
            }
            int n4 = Integer.parseInt(this.cell.getRichStringCellValue().toString().trim());
            return n4;
        }
    }

    public float getFloat(int n, int n2) {
        HSSFCell hSSFCell = this.getCell(n, n2);
        if (hSSFCell == null) {
            PApplet.println((String)"ERR, getFloat(): cell is null");
        }
        if (!this.isCellType(hSSFCell, 0)) {
            PApplet.println((String)"ERR, getFloat(): wrong celltype");
        }
        try {
            float f = (float)hSSFCell.getNumericCellValue();
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.showWarnings) {
                PApplet.println((String)("ERR, getFloat(" + n + "," + n2 + "): you are reading a text cell as float."));
            }
            float f = Float.parseFloat(hSSFCell.getRichStringCellValue().toString().trim());
            return f;
        }
    }

    public String getString(int n, int n2) {
        String string;
        block5: {
            this.cell = this.getCell(n, n2);
            if (this.cell == null) {
                PApplet.println((String)"ERR, getString(): cell is null");
            }
            if (!this.isCellType(this.cell, 1)) {
                PApplet.println((String)"ERR, getString(): wrong celltype");
            }
            string = null;
            try {
                string = this.cell.getRichStringCellValue().toString();
            }
            catch (NumberFormatException numberFormatException) {
                if (!this.showWarnings) break block5;
                PApplet.println((String)("ERR, getString(" + n + "," + n2 + "): you are reading a numeric cell as string."));
            }
        }
        if (string == null) {
            string = this.cell.getNumericCellValue() + "";
        }
        return string;
    }

    private HSSFCell getCell(int n, int n2) {
        if (this.workBook == null) {
            return null;
        }
        if (this.sheet == null) {
            return null;
        }
        if (this.rowNum != n || this.row == null) {
            this.row = this.sheet.getRow(n);
            this.rowNum = n;
        }
        if (this.row == null) {
            return null;
        }
        this.cell = this.row.getCell((short)n2);
        return this.cell;
    }

    private boolean isCellType(HSSFCell hSSFCell, int n) {
        if (hSSFCell == null) {
            PApplet.println((String)"ERR, isCellType(): given cell is null.");
            return false;
        }
        if (hSSFCell.getCellType() == n) {
            return true;
        }
        switch (hSSFCell.getCellType()) {
            case 1: {
                PApplet.println((String)"HSSFCell.CELL_TYPE_STRING");
                break;
            }
            case 0: {
                PApplet.println((String)"HSSFCell.CELL_TYPE_NUMERIC");
                break;
            }
            case 3: {
                PApplet.println((String)"HSSFCell.CELL_TYPE_BLANK");
            }
        }
        return false;
    }
}

